#!/bin/bash

## ENV value is read from system variable etc profile.d

if [ "$ENV" == "dev" ]; then
  echo "$ENV environment."
  ECR_REPOSITORY_URL="984815472583.dkr.ecr.us-east-1.amazonaws.com/brandslice-dev-shopify-app"
  IMAGE_TAG="latest"
elif [ "$ENV" == "prod" ]; then
  echo "$ENV environment."
  ECR_REPOSITORY_URL="984815472583.dkr.ecr.us-east-1.amazonaws.com/brandslice-prod-shopify-app"
  IMAGE_TAG="latest"
else
  echo "Invalid environment: $ENV."
  exit 1
fi

# Stop the container
cd /opt/data/brandslice-shopify-app && docker-compose down

# Pull the latest image from ECR
aws ecr get-login-password --region us-east-1 | docker login --username AWS --password-stdin 984815472583.dkr.ecr.us-east-1.amazonaws.com
docker pull ${ECR_REPOSITORY_URL}:${IMAGE_TAG}

# Start the container
cd /opt/data/brandslice-shopify-app && docker-compose up -d

#End
