import { authenticate } from "../shopify.server";
import db from "../db.server";

export const action = async ({ request }) => {
  const { topic, shop, session, admin } = await authenticate.webhook(request);
  // console.log(topic,shop,session,admin, 'Webhook topic');

  if (!admin && topic !== "SHOP_REDACT") {
    // The admin context isn't returned if the webhook fired after a shop was uninstalled.
    // The SHOP_REDACT webhook will be fired up to 48 hours after a shop uninstalls the app.
    // Because of this, no admin context is available.
    throw new Response();
  }

  // The topics handled here should be declared in the shopify.app.toml.
  // More info: https://shopify.dev/docs/apps/build/cli-for-apps/app-configuration
  switch (topic) {
    case "APP_UNINSTALLED":
      if (session) {
        console.log('triggered');
        await db.shopify_session.delete({ where: { id: session.id } });
      }
      break;
    case "CUSTOMERS_DATA_REQUEST":
      console.log('its working');
      break;
    case "CUSTOMERS_REDACT":
      console.log('its working');
      break;
    case "SHOP_REDACT":
      if (session) {
        console.log('its working');
      }
      break;
    default:
      throw new Response("Unhandled webhook topic", { status: 404 });
  }

  throw new Response();
};
