<?php
/*
 * Plugin Name: GPT-BUSINESS.APP AI CHATBOT & LIVE CHAT SOLUTION
 * Description: An advanced AI chatbot and live chat solution for WordPress, enhancing user engagement with intelligent interactions and real-time support.
 * Version: 1.1
 * Author: Team GPT Business
 * Author URI: https://gpt-business.app
 * License: GPL v2 or later
 */

add_action('wp_head', 'add_my_custom_script');

function add_my_custom_script() {
    $bot_id = get_option('my_custom_bot_id', 'default-bot-id');
    $user_id = get_option('my_custom_user_id', 'default-user-id');
    ?>
    <!-- Custom Script Start -->
    <script src="https://gptbusinesslogos.blob.core.windows.net/gptbusiness/chatgptbusiness.js" 
    data-bot-id="<?php echo esc_attr($bot_id); ?>" 
    data-user-id="<?php echo esc_attr($user_id); ?>"></script>
    <!-- Custom Script End -->
    <?php
}

// Add admin menu
add_action('admin_menu', 'my_custom_script_menu');

function my_custom_script_menu() {
    add_options_page(
        'GPT Business Chatbot Settings', 
        'GPT Business Chatbot Settings',
        'manage_options',
        'my-custom-script-settings',
        'my_custom_script_settings_page'
    );
}

// Settings page content
function my_custom_script_settings_page() {
    ?>
    <div class="wrap">
        <h1>Gpt Business App Chatbot Settings</h1>
        <form method="post" action="options.php">
            <?php
            settings_fields('my-custom-script-settings-group');
            do_settings_sections('my-custom-script-settings-group');
            ?>
            <table class="form-table">
                <tr valign="top">
                    <th scope="row">Bot ID</th>
                    <td>
                        <input type="text" name="my_custom_bot_id" value="<?php echo esc_attr(get_option('my_custom_bot_id')); ?>" />
                        <p class="description">Provide the unique Bot Id for your bot.</p>
                    </td>
                </tr>

                <tr valign="top">
                    <th scope="row">User ID</th>
                    <td>
                        <input type="text" name="my_custom_user_id" value="<?php echo esc_attr(get_option('my_custom_user_id')); ?>" />
                        <p class="description">Provide the user ID that will be associated with this bot. This ID helps in managing user-specific data and preferences.</p>
                    </td>
                </tr>
            </table>

            <?php submit_button(); ?>
        </form>
    </div>
    <?php
}

// Register settings
add_action('admin_init', 'register_my_custom_script_settings');

function register_my_custom_script_settings() {
    register_setting('my-custom-script-settings-group', 'my_custom_bot_id');
    register_setting('my-custom-script-settings-group', 'my_custom_user_id');
}