from django.http import JsonResponse, HttpResponse
from .decorators.login import login,superuser_login
from rest_framework.decorators import api_view
from .models import *
from django.views.decorators.csrf import csrf_exempt
from django.conf import settings
import json
import uuid
import datetime
from rest_framework.permissions import AllowAny
from rest_framework.decorators import permission_classes
from django.core import serializers
from django.core.cache import cache
import stripe
from urllib.parse import urlparse
from django.db.models import Sum
from collections import Counter
import stripe
import datetime
from azure.communication.email import EmailClient
import pinecone
from langchain.embeddings import OpenAIEmbeddings
from langchain.vectorstores import Pinecone
import base64
import datetime
import os, sys

stripe.api_key=settings.STRIPE_SECRET_KEY

def send_email(subject,body,recipient,recipient_name):
    email_client = EmailClient.from_connection_string(settings.EMAIL_CONNECTION_STRING)
    message = {
        "content": {
            "subject": subject,
            "html": body
        },
        "recipients": {
            "to": [
                {
                    "address": recipient,
                    "displayName": recipient_name
                }
            ]
        },
        "senderAddress": "donotreply@gpt-business.app"
    }
    poller = email_client.begin_send(message)
    return poller.result()

@api_view(['POST','GET'])
@permission_classes([AllowAny])
def custom_jwt_authentication(request):
    try:
        if request.method == 'POST':
            from rest_framework_simplejwt.tokens import RefreshToken

            username = request.data['username']
            password = request.data['password']
            profile=''
            if username and password:
                user = User.objects.filter(username=username)
                if not user.exists():
                    return JsonResponse({"status":"error","msg":"Wrong credentials."},status=401)
                else:
                    user=user[0]
                    profile=Profile.objects.get(user=user)
                
                if not user.check_password(password):
                    profile.invalid_login_attempts+=1
                    if profile.invalid_login_attempts>=3:
                       profile.save()
                       return JsonResponse({"status":"error","msg":"Your account has been blocked due to multiple invalid login attempts. Please reset your password to continue."},status=401)
                    else: 
                        profile.save()
                        return JsonResponse({"status":"error","msg":"Wrong credentials."},status=401)
                else:
                    if profile.invalid_login_attempts>=3:
                        return JsonResponse({"status":"error","msg":"Your account has been blocked due to invalid login attempts. Please reset your password to continue."},status=401)
                if user:
                    profile.invalid_login_attempts=0
                    profile.save()
                    refresh = RefreshToken.for_user(user)
                    access_token = str(refresh.access_token)
                    refresh_token = str(refresh)
                    if datetime.datetime.today().date()>profile.valid_till:
                        return JsonResponse({
                            "blocked":{
                                "status":True,
                                "reason":"unpaid"
                            },
                            'access_token': access_token, 'refresh_token': refresh_token, "profile_id":str(profile.uid),"plan":profile.plan
                            })
                    else:
                        return JsonResponse({'access_token': access_token, 'refresh_token': refresh_token, "profile_id":str(profile.uid),"plan":profile.plan})
        return JsonResponse({
                    'status':"Invalid credentials"
                })
    except:
        return JsonResponse({"status":'err',"msg":"Something went wrong."},status=500)

def password_check(passwd):
    SpecialSym =['$', '@', '#', '%','~','^','!','(',')','[',']',"'"]
    val = True
     
    if len(passwd) < 8:
        val = False
           
    if not any(char.isdigit() for char in passwd):
        val = False
         
    if not any(char.isupper() for char in passwd):
        val = False
         
    if not any(char.islower() for char in passwd):
        val = False
         
    if not any(char in SpecialSym for char in passwd):
        val = False
    if val:
        return val

@api_view(['POST','GET'])
@login
def authenticate(request,user):
    profile=Profile.objects.filter(user=user).values('plan','chat_credit','valid_till','analytics_valid_till')
    return JsonResponse({
        "profile":list(profile),
        "status":200
    })

@csrf_exempt
def index(request):
    return JsonResponse({},status=200)

#This function will work in the side of chatbot_agent.
@csrf_exempt
def update_database(request):
    try:
        data=dict(request.POST)
        if 'unsaved_profiles' in data:
            all_plans=Plans.objects.all()
            plans={}
            for plan in all_plans:
                plans[plan.type]=plan
            bots=json.loads(data['unsaved_profiles'][0])
            for profile_id,usage in bots.items():
                profile=Profile.objects.filter(uid=profile_id.split('_')[1])
                plan=profile[0].plan
                monthly_chat_credit=plans[plan].monthly_chat_credit
                chat_credit=profile[0].chat_credit
                
                if usage < monthly_chat_credit:
                    profile.update(message_usage=usage)
                elif usage > monthly_chat_credit:
                    profile.update(message_usage=usage,chat_credit=profile[0].chat_credit+monthly_chat_credit-usage)
        return JsonResponse({},status=200)
    except:
        return JsonResponse({},status=500)

@api_view(['POST','GET'])
@login
def handle_bot(request,user):
    #in -> [access_key,refresh_key,action,]
    try:
        action=request.data['action']
        if action=="create":
            #in -> [name,description]
            profile=Profile.objects.get(user=user)
            plan=profile.plan
            plan=Plans.objects.get(type=plan)
            old_bots=Bot.objects.filter(user=user)
            if old_bots.count()<plan.chatbot_credit:
                name=request.data["name"]
                description=request.data["description"]
                appearance=request.data["appearance"]
                bot=Bot(name=name,profile=profile,user=user,description=description,appearance=appearance)
                bot.save()
                return JsonResponse({
                    'bot_id':bot.uid
                },status=201)
            else:
                return JsonResponse({
                    'status':"err",
                    "msg":f"You can only have a maximum of {plan.chatbot_credit} in your {plan.name} plan."
                },status=401)
        elif action=='update':
            element=request.data["element"]
            bot_id=request.data["bot_id"]
            profile=Profile.objects.get(user=user)
            bot=Bot.objects.filter(uid=bot_id,user=user)
            if element=='appearance':
                name=request.data["name"]
                description=request.data["description"]
                appearance=request.data["appearance"]
                initial_message=request.data["initial_message"]
                bot.update(name=name,description=description,appearance=appearance,initial_message=initial_message)
            elif element=='security':
                visibility=request.data["visibility"]
                allowed_domains=request.data["allowed_domains"]
                lst=[]
                if allowed_domains:
                    for url in allowed_domains:
                        url = urlparse(url).hostname
                        lst.append(url)
                allowed_domains=lst
                allowed_domains=json.dumps(allowed_domains)
                bot.update(visibility=visibility,allowed_domains=allowed_domains)
                bot_cache=cache.get(bot_id)
                if bot_cache and "conf" in bot_cache:
                    bot_cache['conf']["visibility"]=visibility
                    bot_cache['conf']["allowed_domains"]=allowed_domains
                    cache.set(bot_id,bot_cache)
                model=request.data["model"]
                if profile.plan=='basic' or profile.plan=='starter':
                    if model=='gpt-4':
                        model="gpt-3.5-turbo"
                prompt=request.data['prompt']
                temperature=request.data['temperature']
                bot.update(model=model,prompt=prompt,temperature=temperature)
                bot_cache=cache.get(bot_id)
                if bot_cache and "conf" in bot_cache:
                    bot_cache['conf']["model"]=model
                    bot_cache['conf']["prompt"]=prompt
                    bot_cache['conf']["temperature"]=temperature
                    cache.set(bot_id,bot_cache)
            return JsonResponse({},status=200)
        elif action=='delete':
            bot_id=name=request.data['bot_id']
            bot=Bot.objects.filter(uid=bot_id,user=user)
            bot.delete()
            return JsonResponse({},status=200)
    except:
        return JsonResponse({"status":'err',"msg":"Something went wrong."},status=500)


@api_view(['POST','GET'])
@login
def bots_list(request,user):
    #in -> [access_key]
    try:
        bots=Bot.objects.filter(user=user).values("name","uid")
        return JsonResponse({
            'bots':list(bots)
        },status=200)
    except:
        
        return JsonResponse({
            'bots':list(bots)
        },status=500)

@api_view(['POST','GET'])
@login
def all_conversations(request,user):
    #in -> [access_key,bot_id]
    try:
        bot_id=request.data['bot_id']
        bot=Bot.objects.get(uid=bot_id,user=user)
        conversations=Conversation.objects.filter(bot=bot).values('uid','name','email','date_updated','bookmarked','liked')
        return JsonResponse({
            'convs':list(conversations)
        },status=200)
    except:
        return JsonResponse({},status=500)
        

@api_view(['POST','GET'])
@login
def bot_info(request,user):
    #in -> [access_key,bot_id]
    try:
        bot_id=request.data['bot_id']
        bot=Bot.objects.filter(uid=bot_id,user=user).values("name","description","initial_message","prompt","temperature","appearance","allowed_domains","visibility","model")
        return JsonResponse(list(bot)[0],status=200)
    except:
        return JsonResponse({},status=500)

@api_view(['POST','GET'])
@csrf_exempt
def get_bot_conf(request):
    try:
        bot_id=request.data['bot_id']
        bot=Bot.objects.get(uid=bot_id)
        return JsonResponse({
            "model":bot.model,
            "prompt":bot.prompt,
            "temperature":bot.temperature
        },status=200)
    except:
        
        return JsonResponse({},status=500)

@api_view(['POST','GET'])
@csrf_exempt
def add_unverified(request):
    try:
        #in -> [email,name,password1,password2,country,orgnisation]
        email=request.data['email']
        name=request.data['name']
        password1=request.data['password1']
        password2=request.data['password2']
        country=request.data['country']
        organisation=request.data['organisation']
        phone=request.data['organisation']
        if password1!=password2:
            return JsonResponse({
                'status':'err',
                'msg':'The passwords you entered do not match.'
            })
        elif not password_check(password1):
            return JsonResponse({
                    'status':'err',
                    'msg':'The password you entered is not strong. Please enter again.'
                },status=401)

        old_user=Unverified.objects.filter(email=email)
        existing=User.objects.filter(email=email)
        
        if existing.exists():
            return JsonResponse({
                'status':'err',
                'msg':'User already exists. Please login.'
            },status=201)
        
        token=str(uuid.uuid4())+'_'+datetime.datetime.now().strftime("%Y%m%d-%H%M%S")
        if not old_user.exists():
            user=Unverified(name=name,email=email,password=password1,country=country,organisation=organisation,email_token=token,phone=phone)
            user.save()
        else:
            old_user.update(token=token)
        
        send_email("Welcome to GPT Business - Email Verification Required",f'''
                <!DOCTYPE html>
                <html lang="en">
                <head>
                    <meta charset="UTF-8">
                    <meta http-equiv="X-UA-Compatible" content="IE=edge">
                    <meta name="viewport" content="width=device-width, initial-scale=1.0">
                    <title>Email Verification</title>
                </head>
                <body>
                    <p>Hello {name},</p>
                    
                    <p>Welcome to GPT Business! We're excited to have you on board. To complete your registration, please click the link below to verify your email address:</p>

                    <p>
                        <a href="https://app.gpt-business.app/verify-email?token={token}" target="_blank" style="display: inline-block; padding: 10px 20px; background-color: #007BFF; color: #ffffff; text-decoration: none; border-radius: 5px;">Verify Email</a>
                    </p>

                    <p>If you didn't create an account on GPT Business, you can safely ignore this email.</p>

                    <p>Thank you,<br>No-Reply Team<br>GPT Business</p>
                </body>
                </html>
        ''',email,name)
        return JsonResponse({
            "status":'success',
            "msg":"We have sent you a verification email on '"+email+"'. Please verify to enjoy our services."
        }, status=201)
    except:
        return JsonResponse({
            'status':'err',
            'msg':'Something went wrong.'
        },status=500)
    
@api_view(['POST','GET'])
@csrf_exempt
def verify_email(request):
    try:
        #in -> [email_token]
        import datetime
        token=request.data['token']
        old_user=Unverified.objects.filter(email_token=token)
        if old_user.exists():
            old_user=old_user[0]
            new_user=User.objects.create_user(first_name=old_user.name,email=old_user.email,password=old_user.password,username=old_user.email)
            new_user.save()
            import uuid
            import random
            t=2 ** 48 - 1
            key=uuid.uuid1(random.randint(0, t))
            profile=Profile(email=old_user.email,api_key=key,user=new_user,organisation=old_user.organisation,Country=old_user.country,valid_till=datetime.date.today()+datetime.timedelta(days=5),plan='free',phone=old_user.phone)
            profile.save()
            old_user.delete()
            return JsonResponse({
                'status':'success',
                'msg':'Your email has been verified. Now you can login using your credentials.'
            },status=201)
        else:
            return JsonResponse({
            'status':'err',
            'msg':'Token expired.'
        },status=200)
    except:
        
        return JsonResponse({
            'status':'err',
            'msg':'Something went wrong.'
        },status=500)
    
@api_view(['POST','GET'])
@csrf_exempt
def reset_password(request):
    try:
        #in -> [action]
        """if action is 'forgot' then pass email else pass 'email_token','password1','password2'"""
        import datetime
        action=request.data['action']
        if action=='forgot':
            email=request.data['email']
            users=User.objects.filter(email=email)
            if users.exists():
                profile=Profile.objects.filter(user=users[0])
                token=str(uuid.uuid4())+'_'+datetime.datetime.now().strftime("%Y%m%d-%H%M%S")
                profile.update(reset_token=token)

                send_email("Reset GPT Business Password",f'''
                <!DOCTYPE html>
                <html lang="en">
                <head>
                    <meta charset="UTF-8">
                    <meta http-equiv="X-UA-Compatible" content="IE=edge">
                    <meta name="viewport" content="width=device-width, initial-scale=1.0">
                    <title>Email Verification</title>
                </head>
                <body>
                    <p>Hello {users[0].first_name},</p>
                    
                    <p>Click the link below to reset your password.</p>

                    <p>
                        <a href="https://app.gpt-business.app/change-password?token={token}" target="_blank" style="display: inline-block; padding: 10px 20px; background-color: #007BFF; color: #ffffff; text-decoration: none; border-radius: 5px;">Change password</a>
                    </p>

                    <p>If you didn't requested for changing your account's password, you can safely ignore this email.</p>

                    <p>Thank you,<br>No-Reply Team<br>GPT Business</p>
                </body>
                </html>
        ''',users[0].email,users[0].first_name)

                return JsonResponse({
                    'status':'success',
                    'msg':"We have sent a verification mail on {mail} to reset your password. Please check your inbox.".format(mail=users[0].email)
                },status=200)
            else:
                return JsonResponse({
                    'status':'err',
                    'msg':"This email address is not registered with us."
                },status=200)
        elif action=='reset':
            token=request.data['token']
            password1=request.data['password1']
            password2=request.data['password2']
            if password1!=password2:
                return JsonResponse({
                    'status':'err',
                    'msg':'Passwords do not match.'
                })
            elif not password_check(password1):
                return JsonResponse({
                    'status':'err',
                    'msg':'Password is not strong. Please choose a strong password.'
                })
            else:
                profile=Profile.objects.filter(reset_token=token)
                if profile.exists():
                    user=profile[0].user
                    user.set_password(password1)
                    user.save()
                    profile.update(reset_token='',invalid_login_attempts=0)
                    return JsonResponse({
                    'status':'success',
                    'msg':'Successfully changed your password.'
                    })
                else:
                    return JsonResponse({
                    'status':'err',
                    'msg':'Token has expired.'
                    })
    except:
        
        return JsonResponse({
            'status':'err',
            'msg':'Something went wrong.'
        },status=500)

@api_view(['POST','GET'])
@login
def checkout(request,user):
    try:
        data=json.loads(request.data['data'])
        price_id=''

        rate=Rate.objects.all()
        profile=Profile.objects.get(user=user)
        if 'plan' in data:
            plan_type=data['plan']
        if 'duration' in data and data['duration']=='monthly':
            if 'plan' in data:
                plan=Plans.objects.get(type=plan_type)
                price_id=plan.monthly_price_id
        elif 'duration' in data and data['duration']=='yearly':
            if 'plan' in data:
                plan=Plans.objects.get(type=plan_type)
                price_id=plan.yearly_price_id

        if 'messages' in data:
            price=0
            price+=data['messages']*int(rate[0].message)
            session = stripe.checkout.Session.create(
                client_reference_id=user.id if user.is_authenticated else None,
                customer_email=user.email,
                line_items=[{
                    'price_data': {
                        'currency': 'usd',
                        'product_data': {
                            'name': str(data['messages']*1000)+' Chat credits',
                        },
                        'unit_amount': price,
                    },
                    'quantity': 1,
                }],
                metadata={'messages': data['messages']},
                mode='payment',
                success_url='https://app.gpt-business.app/payment/success/',
                cancel_url='https://app.gpt-business.app/payment/failed/',
            )
            return JsonResponse({
                'status':'success',
                'session_url':session['url'],
                'publishable_key':settings.STRIPE_PUBLISHABLE_KEY
            },status=200)
        
        if 'watermark' in data:
            price=0
            price+=rate[0].watermark
            session = stripe.checkout.Session.create(
                client_reference_id=user.id if user.is_authenticated else None,
                customer_email=user.email,
                line_items=[{
                    'price_data': {
                        'currency': 'usd',
                        'product_data': {
                            'name': "Custom branding",
                        },
                        'unit_amount': price,
                    },
                    'quantity': 1,
                }],
                metadata={'watermark': True},
                mode='payment',
                success_url='https://app.gpt-business.app/payment/success/',
                cancel_url='https://app.gpt-business.app/payment/failed/'
            )
            return JsonResponse({
                'status':'success',
                'session_url':session['url'],
                'publishable_key':settings.STRIPE_PUBLISHABLE_KEY
            },status=200)

        stripe.api_key=settings.STRIPE_SECRET_KEY
        valid_till=profile.valid_till
        time_delta=(valid_till-datetime.datetime.today().date()).days

        if time_delta > 0 and profile.plan=='free' and 'plan' in data:
            session = stripe.checkout.Session.create(
                client_reference_id=user.id if user.is_authenticated else None,
                customer_email=user.email,
                line_items=[{
                            'price': price_id,
                            'quantity': 1,
                        }],
                mode='subscription',
                subscription_data={
                    'trial_period_days':time_delta
                },
                success_url='https://app.gpt-business.app/payment/success/',
                cancel_url='https://app.gpt-business.app/payment/failed/',
            )
        else:
            session = stripe.checkout.Session.create(
                client_reference_id=user.id if user.is_authenticated else None,
                customer_email=user.email,
                line_items=[{
                            'price': price_id,
                            'quantity': 1,
                        }],
                mode='subscription',
                success_url='https://app.gpt-business.app/payment/success/',
                cancel_url='https://app.gpt-business.app/payment/failed/'
            )
    
        return JsonResponse({
            'status':'success',
            'session_url':session['url'],
            'publishable_key':settings.STRIPE_PUBLISHABLE_KEY
        },status=200)
    except:
        return JsonResponse({
            'status':'err',
            'msg':'Something went wrong. Please try again.'
        },status=500)

@api_view(['POST','GET'])
@login
def upgrade_plan(request,user):
    try:
        requested_plan=request.data["plan"]
        duration=request.data['duration']
        profile=Profile.objects.get(user=user)
        plan=Plans.objects.filter(type=requested_plan)
        existing_subscription_id = profile.stripe_subscription_id
        customer_id=profile.stripe_customer_id

        if plan.count()==0:
            return JsonResponse({"status":"err","msg":"Plan does not exist."},status=400)
        else:
            plan=plan[0]
        if duration=='monthly':
            new_price_id=plan.monthly_price_id
        elif duration=="yearly":
            new_price_id=plan.yearly_price_id
        else:
            return JsonResponse({"status":"err","msg":"Sorry, you request can not be processed at the moment."},status=400)

        existing_subscription = stripe.Subscription.retrieve(existing_subscription_id)

        if existing_subscription['items']['data'][0]['price']['id'] != new_price_id:
            subscription = existing_subscription
            current_plan_amount = subscription['items']['data'][0]['price']['unit_amount']
            current_item_id=subscription['items']['data'][0]['id']
            new_plan = stripe.Price.retrieve(new_price_id)
            new_plan_amount = new_plan['unit_amount']
            prorated_amount = new_plan_amount - current_plan_amount

            stripe.InvoiceItem.create(
                customer=customer_id,
                amount=prorated_amount,
                currency='usd',
                description='Prorated charge for plan upgrade',
            )

            # Create an invoice with metadata and attempt to pay it
            invoice = stripe.Invoice.create(
                customer=customer_id,
                auto_advance=True, # Automatically finalize and attempt to pay the invoice
                metadata={"change_plan":True,"price_id":new_price_id,"subscription_id":existing_subscription_id,"current_item_id":current_item_id}
            )
            try:
                # Attempt to pay the invoice
                stripe.Invoice.pay(invoice['id'])
                stripe.Subscription.modify(
                    existing_subscription_id,
                    items=[{
                        'id': current_item_id,
                        'price': new_price_id,
                    }]
                )
                return JsonResponse({
                    "msg":"Payment Successful."
                },status=200)
            except stripe.error.StripeError as e:
                return JsonResponse({
                    "msg":"Payment Failed."
                },status=200)
        else:
            return JsonResponse({"status":"err","msg":"You have already opted for the given plan."},status=400)
    except:
        return JsonResponse({
            "status":"err",
            "msg":"Something went wrong. Please try again after some time."
        },status=500)

@api_view(['POST','GET'])
@csrf_exempt
def stripe_webhook(request):
    stripe.api_key = settings.STRIPE_SECRET_KEY
    endpoint_secret = "whsec_3484c2f6db046c9bd736aae23a5bbbe3cc4812a7064b0de1738ceffd3c0c1a84"
    payload = request.body.decode('utf-8')
    sig_header = request.META['HTTP_STRIPE_SIGNATURE']
    event = None
    price_id=""

    try:
        event = stripe.Webhook.construct_event(
            payload, sig_header, endpoint_secret
        )
    except ValueError as e:
        return HttpResponse(status=400)
    except stripe.error.SignatureVerificationError as e:
        return HttpResponse(status=400)
    # Handle the checkout.session.completed event
    try:
        user=''
        email=''
        if event['type']=="checkout.session.completed":
            session = event['data']['object']
            data=session['metadata']
            email=session["customer_details"]["email"]
            user=User.objects.get(email=email)
            profiles=Profile.objects.filter(user=user)
            profile=profiles[0]
            
            #Check if plan
            plans=Plans.objects.all()
            if 'messages' in data:
                credit=profile.chat_credit+int(data['messages'])*1000
                profiles.update(chat_credit=credit)

                profile_cache=cache.get("profile_"+str(profile.uid))
                if profile_cache:
                    profile_cache["message_usage"]+=credit
                    profile_cache["token_usage"]+=credit
                    cache.set("profile_"+str(profile.uid),profile_cache)
            elif 'watermark' in data:
                profiles.update(remove_watermark_forever=True)

        if event["type"]=="customer.subscription.updated":
            plans=Plans.objects.all()
            session = event['data']['object']
            data=session['metadata']
            stripe_customer_id = session['customer']
            profiles=Profile.objects.filter(stripe_customer_id=stripe_customer_id)
            profile=profiles[0]
            price_id=session['items']['data'][0]['plan']['id']
            interval = session['items']['data'][0]['plan']['interval']
            end_date = session['current_period_end' ]
            valid_till_date=datetime.datetime.utcfromtimestamp(end_date).date()
            plan=""
            monthly_plan=plans.filter(monthly_price_id=price_id)
            yearly_plan=plans.filter(yearly_price_id=price_id)
            if monthly_plan.count():
                plan=monthly_plan
            elif yearly_plan.count():
                plan=yearly_plan
            
            if plan!="" and plan.count():
                plan=plan[0]
                if interval=='month':
                    valid_till=valid_till_date
                    if plan.custom_branding:
                        profiles.update(remove_watermark=True,plan=plan.type,valid_till=valid_till,last_updated_on=datetime.date.today(),plan_duration="monthly")
                    else:
                        profiles.update(remove_watermark=False,plan=plan.type,valid_till=valid_till,last_updated_on=datetime.date.today(),plan_duration="monthly")

                elif interval=='year':
                    valid_till=valid_till_date
                    if plan.custom_branding:
                        profiles.update(remove_watermark=True,plan=plan.type,valid_till=valid_till,last_updated_on=datetime.date.today(),plan_duration="yearly")
                    else:
                        profiles.update(remove_watermark=False,plan=plan.type,valid_till=valid_till,last_updated_on=datetime.date.today(),plan_duration="yearly")
                #Update cache
                profile_cache=cache.get("profile_"+str(profile.uid))
                if profile_cache:
                    profile_cache["plan"]=plan.type
                    cache.set("profile_"+str(profile.uid),profile_cache)

        if event['type'] == 'invoice.payment_succeeded' and "lines" in event['data']['object'] and len(event['data']['object']["lines"]):
            plans=Plans.objects.all()
            session = event['data']['object']
            data=session['metadata']
            email = session['customer_email']
            user=User.objects.get(email=email)
            profiles=Profile.objects.filter(user=user)
            profile=profiles[0]
            subscription_id=session['lines']['data'][0]['subscription'] 
            subscription = stripe.Subscription.retrieve(subscription_id)
            price_id=subscription['items']['data'][0]['price']['id']
            plan=""
            monthly_plan=plans.filter(monthly_price_id=price_id)
            yearly_plan=plans.filter(yearly_price_id=price_id)

            if monthly_plan.count():
                plan=monthly_plan
            elif yearly_plan.count():
                plan=yearly_plan

            if profile.plan=="free" and plan.count():
                profile.free_trial_ended=True
                profile.converted_on=datetime.datetime.today().date()
                profile.save()
            
            if plan!="" and plan.count():
                interval=subscription['items']['data'][0]['price']['recurring']['interval']
                next_billing_timestamp = subscription['current_period_end']
                valid_till_date=datetime.datetime.utcfromtimestamp(next_billing_timestamp).date()
                plan=plans[0]
                if interval=='month':
                    valid_till=valid_till_date
                    if plan.custom_branding:
                        profiles.update(remove_watermark=True,plan=plan.type,valid_till=valid_till,last_updated_on=datetime.date.today(),message_usage=0,token_usage=0,storage_usage=0,stripe_customer_id=subscription['customer'],stripe_subscription_id=subscription_id,plan_duration="monthly")
                    else:
                        profiles.update(remove_watermark=False,plan=plan.type,valid_till=valid_till,last_updated_on=datetime.date.today(),message_usage=0,token_usage=0,storage_usage=0,stripe_customer_id=subscription['customer'],stripe_subscription_id=subscription_id,plan_duration="monthly")

                elif interval=='year':
                    valid_till=valid_till_date
                    if plan.custom_branding:
                        profiles.update(remove_watermark=True,plan=plan.type,valid_till=valid_till,last_updated_on=datetime.date.today(),message_usage=0,token_usage=0,storage_usage=0,stripe_customer_id=subscription['customer'],stripe_subscription_id=subscription_id,plan_duration="yearly")
                    else:
                        profiles.update(remove_watermark=False,plan=plan.type,valid_till=valid_till,last_updated_on=datetime.date.today(),message_usage=0,token_usage=0,storage_usage=0,stripe_customer_id=subscription['customer'],stripe_subscription_id=subscription_id,plan_duration="yearly")
                #Update cache
                profile_cache=cache.get("profile_"+str(profile.uid))
                if profile_cache:
                    profile_cache["message_usage"]=0
                    profile_cache["token_usage"]=0
                    cache.set("profile_"+str(profile.uid),profile_cache)

            invoice=Invoice(email=email,user=user,user_name=user.get_full_name(),status='paid',amount=session['amount_paid'],url=session["hosted_invoice_url"])
            invoice.save()
            return HttpResponse(status=200)
        return HttpResponse(status=200)
    except:
        return HttpResponse(status=400)
    
@api_view(['POST','GET'])
@csrf_exempt
def get_profile(request):
    try:
        id=request.GET.get('id')
        profile=Profile.objects.get(uid=id)
        plan=Plans.objects.get(type=profile.plan)
        subscription_status="subscribed"
        if profile.cancel_requested:
            subscription_status="cancelled"
        elif profile.plan=='free':
            subscription_status="unsubscribed"
        params={
            "plan":profile.plan,
            "validity":profile.valid_till,
            "chat_credit":plan.chat_credit,
            "monthly_chat_credit":profile.monthly_chat_credit,
            "message_usage":profile.message_usage,
            "token_usage":profile.token_usage,
            "subscription_status":subscription_status
        }
        return JsonResponse({
            "data":params
        },status=200)
    except:
        return JsonResponse({},status=500)

@api_view(['POST','GET'])
@csrf_exempt
def create_conversation(request):
    #in -> [bot_id]
    try:
        bot_id=request.GET['bot_id']
        bot=Bot.objects.get(uid=bot_id)
        conversation=Conversation(bot=bot)
        conversation.save()
        conv_id=conversation.uid
        return JsonResponse({
            "conv_id":conv_id
        },status=201)
    except:
        return JsonResponse({},status=500)

@api_view(['POST','GET'])
@csrf_exempt
def get_conversation(request):
    #in -> [conv_id]
    try:
        conv_id=request.GET.get("conv_id")
        conv=Conversation.objects.get(uid=conv_id)
        return JsonResponse({
            "conv":serializers.serialize('json', [ conv ])
        },status=200)
    except:
        
        return JsonResponse({},status=500)    

@api_view(['POST','GET'])
@csrf_exempt
def update_conversation(request):
    #in -> [access_key,bot_id]
    try:
        conv=""
        if "bookmarked" in request.data:
            conv=Conversation.objects.get(uid=request.data["conv_id"])
            if request.data["bookmarked"]=="true":
                conv.bookmarked=True
            elif request.data["bookmarked"]=="false":
                conv.bookmarked=False
        elif "liked" in request.data:
            conv=Conversation.objects.get(uid=request.data["conv_id"])
            if request.data["liked"]=="true":
                conv.liked=True
            elif request.data["liked"]=="false":
                conv.liked=False
        else:
            data=request.data["data"]
            conv=Conversation.objects.get(uid=data["conv_id"])
            conv.name=data['name']
            conv.email=data['email']
            conv.profile_completed=data["profile_completed"]
            conv.messages=json.dumps(data['messages'])
            conv.total_messages=len(data['messages'])
            conv.incorrect_answers=data['incorrect_answers']
            conv.profile_completed=data['profile_completed']
        conv.save()
        return JsonResponse({},status=200)
    except:
        return JsonResponse({},status=500)
    
@api_view(['POST','GET'])
@csrf_exempt
def delete_conversation(request):
    #in -> [conv_id]
    try:
        conv=Conversation.objects.get(uid=request.data["conv_id"])
        conv.delete()
        return JsonResponse({},status=200)
    except:
        
        return JsonResponse({},status=500)

@api_view(['POST','GET'])
@login
def embeddings(request,user):
    try:
        action=request.data["action"]
        user_id=request.data["user_id"]
        file_type=request.data["file_type"]
        id=''
        bot_id=request.data["bot_id"]
        is_file=request.data["is_file"]
        docs=''
        file_content=""
        file_name=""
        urls=[]
        os.environ["PINECONE_API_KEY"]=settings.PINECONE_API_KEY
        os.environ["PINECONE_ENV"]=settings.PINECONE_ENV
        index_name=settings.KNOWLEDGE_BASE_INDEX_NAME
        profile=Profile.objects.get(user=user)
        bot=Bot.objects.get(uid=bot_id,user=user)
        plan=Plans.objects.get(type=profile.plan)
        id=str(bot.uid)
        authorized_to_create=False

        if is_file:
            file_content=request.data["file_content"]
            file_content=request.data["file_name"]
            file = base64.b64decode(file_content.encode('utf-8'))
            file_name=user_id+datetime.datetime.now().strftime("%Y%m%d-%H%M%S")+'.'+file_type
            with open(file_name, "wb") as fh:
                fh.write(file)
            fh.close()
        
        if action=='add':
            openai_api_key=""
            cache_data=cache.get("api_keys")
            if cache_data and "openai" in cache_data:
                openai_api_key=cache_data["openai"]
            else:
                openai_api_key=Api_keys.objects.get().openai
            
            os.environ["OPENAI_API_KEY"] = openai_api_key
            embeddings_model=OpenAIEmbeddings(openai_api_key=openai_api_key)
            if file_type=='docx':
                from langchain.document_loaders import UnstructuredWordDocumentLoader
                from langchain.text_splitter import CharacterTextSplitter
                loaders = UnstructuredWordDocumentLoader(file_name)
                data=loaders.load()
                text_splitter = CharacterTextSplitter(separator='\n',chunk_size=1000,chunk_overlap=200)
                docs=text_splitter.split_documents(data)
                try:
                    file_path = os.path.join(os.getcwd(), file_name)
                    os.remove(file_path)
                except:
                    pass
            elif file_type=='pdf':
                from langchain.document_loaders import PyPDFLoader
                from langchain.text_splitter import CharacterTextSplitter
                loaders = PyPDFLoader(file_name)
                data=loaders.load_and_split()
                text_splitter = CharacterTextSplitter(separator='\n',chunk_size=1000,chunk_overlap=200)
                docs=text_splitter.split_documents(data)
                try:
                    file_path = os.path.join(os.getcwd(), file_name)
                    os.remove(file_path)
                except:
                    pass
            elif file_type=='url':
                # urls=json.loads(request.data["urls"])
                urls=request.data["urls"]
                from langchain.document_loaders import UnstructuredURLLoader
                from langchain.text_splitter import CharacterTextSplitter
                loaders = UnstructuredURLLoader(urls=urls)
                data=loaders.load()
                text_splitter = CharacterTextSplitter(separator='\n',chunk_size=1000,chunk_overlap=200)
                docs=text_splitter.split_documents(data)

            #Associating id to the knowledge_base
            for doc in docs:
                doc.metadata["bot"]=id

            #Finding total size of the docs
            doc_sizes = [sys.getsizeof(doc) for doc in docs]
            total_size=0

            for index, size in enumerate(doc_sizes):
                total_size+=size

            #Check if authorized to create or not
            old_usage=profile.storage_usage
            if datetime.date.today()<=profile.valid_till:
                if old_usage<plan.storage and old_usage+total_size<plan.storage:
                    authorized_to_create=True
                else:
                    authorized_to_create=False

            #If authorized then finally create the embeddings
            if authorized_to_create:
                pinecone.init(api_key=os.getenv("PINECONE_API_KEY"),environment=os.getenv("PINECONE_ENV"))
                Pinecone.from_documents(docs, embeddings_model, index_name=index_name)

                kb_data=json.loads(bot.kb_data)
                if is_file:
                    if 'file' in kb_data:
                        kb_data['file'].append({"type":file_type,"name":file_name,"date_created":datetime.datetime.today(),"size":total_size})
                    else:
                        kb_data['file']=[{"type":file_type,"name":file_name,"size":total_size}]
                else:
                    if 'urls' in kb_data:
                        for url in urls:
                            kb_data['urls'].append({"url":url,"date_created":datetime.datetime.today(),"size":total_size})
                    else:
                        kb_data['urls']=[{"url":url,"date_created":datetime.datetime.today(),"size":total_size}]
                bot.kb_data=json.dumps(kb_data)
                bot.save()
                profile.storage_usage=old_usage+total_size
                profile.save()
                return JsonResponse({},status=200)
            else:
                return JsonResponse({},status=401)
    except:
        return JsonResponse({},status=500)

@api_view(['POST','GET'])
@login
def kb(request,user):
    try:
        bot_id=request.data["bot_id"]
        bot=Bot.objects.get(user=user,uid=bot_id)
        kb_data=bot.kb_data
        return JsonResponse({"kb_data":kb_data},status=200)
    except:
        return JsonResponse({},status=500)
    
@api_view(['POST','GET'])
@login
def get_credit_info(request,user):
    try:
        profile=Profile.objects.get(user=user)
        plan=Plans.objects.get(type=profile.plan)
        return JsonResponse({
            "chat_credit":profile.chat_credit+profile.monthly_chat_credit,
            "chat_usage":profile.message_usage,
            "token_usage":profile.token_usage,
            "token_credit":plan.context_token,
            "storage_credit":plan.storage,
            "storage_usage":profile.storage_usage
        },status=200)
    except:
        
        return JsonResponse({},status=500)

@api_view(['POST','GET'])
@login
def client_dashboard(request,user):
    try:
        bot=request.data["bot_id"]
        conversations=Conversation.objects.filter(bot=bot)
        total_chats=0
        total_profile_completed=0
        total_correct=0
        for conv in conversations:
            total_chats+=conv.total_messages
            total_correct+=(conv.total_messages-conv.incorrect_answers)
            if conv.profile_completed:
                total_profile_completed+=1
        return JsonResponse({
            "total_chats":total_chats,
            "total_correct_answers":total_correct,
            "total_conversations":len(conversations),
            "leads_generated":total_profile_completed
        },status=200)
    except:
        
        return JsonResponse({},status=500)

@api_view(['POST','GET'])
@login
def list_payment_methods(request,user):
    try:
        profile=Profile.objects.get(user=user)
        customer_id=profile.stripe_customer_id
        customer=stripe.Customer.retrieve(customer_id)
        methods=customer.list_payment_methods().data
        cards=[]
        default_id=''
        for method in methods:
            cards.append(method["card"])
        default_id=customer.invoice_settings.default_payment_method
        return JsonResponse({
            "methods":cards,
            "default_id":default_id
        },status=200)
    except:
        
        return JsonResponse({},status=500)

@api_view(['POST','GET'])
@login
def get_stripe_public_key(request,user):
    try:
        public_key=settings.STRIPE_PUBLISHABLE_KEY
        return JsonResponse({"public_key":public_key},status=200)
    except:
        return JsonResponse({},status=500)

@api_view(['POST','GET'])
@login
def add_payment_method(request,user):
    try:
        profile=Profile.objects.get(user=user)
        customer_id=profile.stripe_customer_id
        setup_intent = stripe.SetupIntent.create(
            customer=customer_id,
            payment_method_types=['card']
        )
        return JsonResponse({
            "client_secret":setup_intent.client_secret
        },status=200)
    except:
        
        return JsonResponse({},status=500)
    
@api_view(['POST','GET'])
@login
def change_default_payment_method(request,user):
    try:
        id=request.data["card_id"]
        profile=Profile.objects.get(user=user)
        customer_id=profile.stripe_customer_id
        stripe.Customer.modify(
            customer_id,
            invoice_settings={'default_payment_method': id},
        )
        return JsonResponse({},status=200)
    except:
        
        return JsonResponse({},status=500)
    
@api_view(['POST','GET'])
@login
def delete_payment_method(request,user):
    try:
        id=request.data["card_id"]
        stripe.PaymentMethod.detach(id)
        return JsonResponse({},status=200)
    except:
        
        return JsonResponse({},status=500)

@api_view(['POST','GET'])
@login
def cancel_subscription(request,user):
    try:
        reason_of_cancellation=request.data["reason"]
        if len(reason_of_cancellation) < 241:
            profile=Profile.objects.get(user=user)
            subscription=profile.stripe_subscription_id
            profile.cancel_requested=True
            profile.cancellation_reason=reason_of_cancellation
            today=datetime.datetime.today().date()
            profile.cancel_requested_date=today
            stripe.Subscription.modify(
                subscription,
                cancel_at_period_end=True,
            )
            terminated=Terminated(email=profile.email,date_joined=profile.date_created,reason=profile.cancellation_reason,cancelled_on=today,paying=True)
            terminated.save()
            profile.save()
            return JsonResponse({},status=200)
        else:
            return JsonResponse({"status":'err',"msg":"Too long reason. Reason can not be greater that 240 charecters."},status=200)
    except:
        
        return JsonResponse({},status=500)

@api_view(['POST','GET'])
@login
def get_client_graph_data(request,user):
    #in -> [access_key,bot_id]
    try:
        bot_id=request.data["bot_id"]
        bot=Bot.objects.get(uid=bot_id)

        #new contacts
        new_contacts_chart={}
        convs=Conversation.objects.filter(bot=bot,date_created__lte=datetime.datetime.today(),date_updated__gt=datetime.datetime.today()-datetime.timedelta(days=365)).values("date_created","total_messages","incorrect_answers")
        date_list=[]
        for conv in convs:
            date_list.append(str(conv['date_created'].date().strftime('%b %Y')))
        date_counts = Counter(date_list)
        new_contacts_chart = dict(date_counts)

        chats_chart={}
        correct_answers={}
        for conv in convs:
            date=conv['date_created'].date().strftime('%b %Y')
            if date in chats_chart:
                chats_chart[date]+=conv["total_messages"]
            else:
                chats_chart[date]=conv["total_messages"]
            if date in correct_answers:
                correct_answers[date]+=conv["total_messages"]-conv["incorrect_answers"]
            else:
                correct_answers[date]=conv["total_messages"]-conv["incorrect_answers"]
        return JsonResponse({
            "new_contacts":new_contacts_chart,
            "chats_chart":chats_chart,
            "correct_answers":correct_answers
        },status=200)
    except:
        
        return JsonResponse({},status=500)

@api_view(['POST','GET'])
@csrf_exempt
def validate_chat(request):
    #in -> [profile_id,bot_id]
    authorized=False
    try:
        profile_id=request.data["profile_id"]
        bot_id=request.data["bot_id"]
        profile=Profile.objects.get(uid=profile_id)
        bot=Bot.objects.get(uid=bot_id,profile=profile)
        origin = request.headers.get("Origin")
        watermark=True

        if datetime.date.today()<=profile.valid_till:
            if bot.visibility!='public' and origin in json.loads(bot.allowed_domains):
                authorized=True
            elif bot.visibility=='public':
                authorized=True
            else:
                authorized=False
        if authorized:
            if profile.remove_watermark or profile.remove_watermark_forever:
                watermark=False
            return JsonResponse({
                "authorized":authorized,
                "bot_conf":{
                    "name":bot.name,
                    "description":bot.description,
                    "initial_message":bot.initial_message,
                    "appearance":bot.appearance,
                    "watermark":watermark
                }
            },status=200)
        else:
            return JsonResponse({"authorized":authorized},status=401)
    except:
        
        return JsonResponse({"authorized":authorized},status=500)
    
@api_view(['POST','GET'])
@login
def get_admin_profile(request,user):
    try:
        return JsonResponse({
            "name":user.get_full_name(),
            "email":user.email
        },status=200)
    except:
        
        return JsonResponse({},status=500)

#Superuser/Superadmin functions
@api_view(['POST','GET'])
@superuser_login
def super_user_dashboard(request,user):
    try:
        profiles=Profile.objects.all()
        annual_subscription_clients=profiles.filter(plan_duration="yearly").count()
        total_clients=profiles.count()-1
        total_new_clients=profiles.filter(date_created__lte=datetime.datetime.today(),date_created__gt=datetime.datetime.today()-datetime.timedelta(days=30)).count()-1
        total_cancellations=profiles.filter(cancel_requested=True).count()
        freemiums=profiles.filter(free_trial_ended=False).count()
        conversions=profiles.filter(converted_on__lte=datetime.datetime.today(),converted_on__gt=datetime.datetime.today()-datetime.timedelta(days=30))
        conversions=conversions.count()
        all_terminates=Terminated.objects.all()
        total_churned_month=all_terminates.filter(date_created__lte=datetime.datetime.today(),date_created__gt=datetime.datetime.today()-datetime.timedelta(days=30)).count()
        if total_new_clients==0:
            total_new_clients=1
        churn_rate_month=(total_churned_month/total_new_clients)*100
        life_list=[]
        average_life=0
        users=User.objects.filter(is_superuser=False).values("date_joined")
        for user in users:
            date_difference=datetime.datetime.now().date()-user['date_joined'].date()
            life_list.append(date_difference.days)

        life_list_len=len(life_list)
        if life_list_len==0:
            life_list_len=1

        average_life=sum(life_list) / life_list_len
        life_time_value=Invoice.objects.aggregate(total_sum=Sum('amount'))['total_sum']
        income_month=0
        invoices=Invoice.objects.filter(date_created__lte=datetime.datetime.today(),date_created__gt=datetime.datetime.today()-datetime.timedelta(days=30)).values('amount')
        for invoice in invoices:
            income_month+=invoice["amount"]
        estimated_income_month=income_month
        plans=Plans.objects.all()
        today = datetime.date.today()
        last_day_of_month = datetime.date(today.year, today.month, 1) + datetime.timedelta(days=32)
        last_day_of_month = last_day_of_month.replace(day=1) - datetime.timedelta(days=1)
        estimated_profiles = profiles.filter(valid_till__gt=today, valid_till__lte=last_day_of_month, cancel_requested=False).exclude(plan='free')
        for profile in estimated_profiles:
            plan=profile.plan
            plan_rate=0
            if profile.plan_duration=='monthly':
                plan_rate=plans.filter(type=plan)[0].price
            elif profile.plan_duration=='yearly':
                plan_rate=plans.filter(type=plan)[0].yearly_price
            estimated_income_month+=plan_rate
        if total_clients==0:
            total_clients=1
        total_churn_rate=(all_terminates.count()/total_clients)*100
        return JsonResponse({
            "total_clients":total_clients,
            "freemiums":freemiums,
            "total_cancellations":total_cancellations,
            "total_new_clients":total_new_clients,
            "churn_rate_month":churn_rate_month,
            "income_month":income_month,
            "conversions_month":conversions,
            "life_time_value":life_time_value,
            "average_life":int(average_life),
            "estimated_income_month":estimated_income_month,
            "annual_subscription_clients":annual_subscription_clients,
            "total_churn_rate":total_churn_rate
            },status=200)
    except Exception as e:
        return JsonResponse({},status=500)
    
@api_view(['POST','GET'])
@superuser_login
def super_user_billing(request,user):
    try:
        invoices=Invoice.objects.all()
        return JsonResponse({'invoices':json.loads(serializers.serialize('json',invoices))})
    except:
        return JsonResponse({},status=500)
    
@api_view(['POST','GET'])
@superuser_login
def super_user_charts(request,user):
    try:
        current_date = datetime.datetime.now()
        twelve_months_ago = current_date - datetime.timedelta(days=365)
        #Monthly churn rate
        monthly_churn_rate_chart={}
        #churn charts
        all_terminates=Terminated.objects.all()
        terminateds = all_terminates.filter(
            date_created__gte=twelve_months_ago,
            date_created__lte=current_date
        ).values("date_created","reason")
        raw_dates=[]
        date_list=[]
        reasons_chart={}
        for data in terminateds:
            raw_dates.append(data['date_created'].date())
            date_list.append(str(data['date_created'].date().strftime('%b %Y')))
        date_counts = Counter(date_list)
        date_counts_dict = dict(date_counts)
        monthly_churn_rate_chart=date_counts_dict
        for date,val in date_counts_dict.items():
            reasons_chart[date]={}
        date_counts = Counter(raw_dates)
        date_counts_dict = dict(date_counts)
        for date in date_counts_dict:
            reasons_lst=[]
            data=all_terminates.filter(date_created__month=date.month, date_created__year=date.year).values('reason')
            for r in data:
                reasons_lst.append(r['reason'])
            reason_counts = Counter(reasons_lst)
            reason_counts_dict = dict(reason_counts)
            reasons_chart[str(date.strftime('%b %Y'))]=reason_counts_dict

        #NOw conversion and cacellations charts
        freemium_chart={}
        all_profiles=Profile.objects.all()
        total_profiles=all_profiles.filter(converted_on__gte=twelve_months_ago,
            converted_on__lte=current_date)
        profiles = total_profiles.values("converted_on")
        total_terminateds=all_terminates.filter(cancelled_on__gte=twelve_months_ago,
            cancelled_on__lte=current_date)
        terminateds=total_terminateds.values('cancelled_on')
        all_filtered_dates={}
        for profile in profiles:
            date=profile["converted_on"].strftime('%b %Y')
            if date in all_filtered_dates:
                all_filtered_dates[date]["conversions"]+=1
            else:
                all_filtered_dates[date]={
                    "conversions":1,
                    "cancelled":0
                }
        for terminated in terminateds:
            date=terminated["cancelled_on"].strftime('%b %Y')
            if date in all_filtered_dates:
                all_filtered_dates[date]["cancelled"]+=1
            else:
                all_filtered_dates[date]={
                    "conversions":0,
                    "cancelled":1
                }
        freemium_chart=all_filtered_dates

        #Paying customers
        paying_customers_chart={}
        date_list=[]
        fixed = all_profiles.filter(date_created__lt=datetime.date.today() - datetime.timedelta(days=365),cancel_requested=False).exclude(plan='free').count()
        for profile in total_profiles.exclude(plan='free'):
            if not profile.cancel_requested:
                date_list.append(profile.date_created.strftime('%b %Y'))
        date_counts = Counter(date_list)
        date_counts_dict = dict(date_counts)
        paying_customers_chart=date_counts_dict
        terminateds=total_terminateds.values('date_joined','date_created')
        for terminated in terminateds:
            joined_date=terminated["date_joined"].strftime('%b %Y')
            date_terminated=terminated["date_created"].strftime('%b %Y')
            if joined_date in paying_customers_chart:
                paying_customers_chart[joined_date]+=1
            else:
                paying_customers_chart[joined_date]=1

            if date_terminated in paying_customers_chart:
                paying_customers_chart[date_terminated]-=1
            else:
                paying_customers_chart[date_terminated]=-1
        for key,val in paying_customers_chart.items():
            paying_customers_chart[key]+=fixed

        return JsonResponse({
            "reasons_chart":reasons_chart,
            "freemium_chart":freemium_chart,
            "monthly_churn_rate_chart":monthly_churn_rate_chart,
            "paying_customers_chart":paying_customers_chart
        },status=200)
    except:
        return JsonResponse({},status=500)
    
@api_view(['POST','GET'])
@superuser_login
def change_superuser_api_keys(request,user):
    try:
        key_name=request.data["key_name"]
        if key_name=="openai":
            key=request.data["key"]
            model=Api_keys.objects.get(openai=key)
            model.openai=key
            model.save()

            cache_data=cache.get("api_keys")
            if cache_data:
                cache_data["openai"]=key
                cache.set("api_keys",cache_data)
            else:
                cache.set("api_keys",{
                    "openai":key
                })
            return JsonResponse({},status=200)
        return JsonResponse({},status=500)
    except:
        return JsonResponse({},status=500)
