from django.db import models
from django.contrib.auth.models import User
import uuid

class Base(models.Model):
    uid=models.UUIDField(primary_key=True, editable=False, default=uuid.uuid4)
    date_created=models.DateTimeField(auto_now_add=True, blank=True)
    date_updated=models.DateTimeField(auto_now_add=True, blank=True)
    class Meta:
        abstract=True

class Profile(Base):
    user=models.OneToOneField(User, on_delete=models.CASCADE, related_name="Profile")
    email=models.CharField(max_length=100, null=True, blank=True)
    phone=models.CharField(max_length=250,default='',blank=True,null=True)
    invalid_login_attempts=models.IntegerField(default=0)
    reset_token=models.CharField(max_length=100, null=True, blank=True)
    organisation=models.CharField(blank=False,null=False,max_length=50, default="")
    Country=models.CharField(blank=False,null=False,max_length=50, default="")
    Basic = "basic"
    Starter="starter"
    Standard='standard'
    Business='business'
    Free='free'
    plan_opt = [
        (Basic, "Basic"),
        (Starter, "Starter"),
        (Standard, "Standard"),
        (Business, "Business"),
        (Free, "Free")
    ]
    plan=models.CharField(
        max_length=20,
        choices=plan_opt,
        default=Free
    )
    Yearly="yearly"
    Monthly="monthly"
    Unselected="unselected"
    plan_duration_opt = [
        (Yearly, "Yearly"),
        (Monthly, "Monthly"),
        (Unselected, "Unselected")
    ]
    plan_duration=models.CharField(
        max_length=20,
        choices=plan_duration_opt,
        default=Unselected
    )
    free_trial_ended=models.BooleanField(default=False)
    last_updated_on=models.DateField(blank=True, null=True)
    valid_till=models.DateField(blank=True, null=True)
    chat_credit=models.IntegerField(default=0,null=False,blank=False)
    monthly_chat_credit=models.IntegerField(default=0,null=False,blank=False)
    chatbot_credit=models.IntegerField(default=0,null=False,blank=False)
    monthly_chatbot_credit=models.IntegerField(default=0,null=False,blank=False)
    message_usage=models.IntegerField(default=0,null=False,blank=False)
    token_usage=models.BigIntegerField(default=0)
    kb_credit=models.IntegerField(default=0,null=False,blank=False)
    monthly_kb_credit=models.IntegerField(default=0,null=False,blank=False)
    remove_watermark=models.BooleanField(default=False)
    remove_watermark_forever=models.BooleanField(default=False)
    cancel_requested=models.BooleanField(default=False)
    cancel_requested_date=models.DateField(blank=True, null=True)
    cancellation_reason=models.CharField(max_length=250,default="",blank=True,null=True)
    storage_usage=models.BigIntegerField(default=0)
    stripe_customer_id=models.CharField(default="",max_length=250,blank=True,null=True)
    stripe_subscription_id=models.CharField(default="",max_length=250,blank=True,null=True)
    converted_on=models.DateField(blank=True,null=True)

class Bot(Base):
    user=models.ForeignKey(User, on_delete=models.CASCADE, related_name="Bot")
    profile=models.ForeignKey(Profile, on_delete=models.CASCADE, related_name="Bot")
    name=models.CharField(max_length=1000,default="",blank=True,null=True)
    description=models.CharField(max_length=1000,default="",blank=True,null=True)
    initial_message=models.TextField(default="")
    kb_data=models.TextField(blank=True,default="{}")
    token_usage=models.BigIntegerField(default=0)
    prompt=models.TextField(null=True,blank=True,default="")
    temperature=models.IntegerField(default=1)
    appearance=models.TextField(null=True,blank=True,default="")
    allowed_domains=models.TextField(null=True,blank=True,default="[]")
    visibility=models.CharField(max_length=100,default="public")
    gpt3_16k = "gpt-3.5-turbo-16k"
    gpt3="gpt-3.5-turbo"
    gpt4="gpt-4"
    ai_models = [
        (gpt3_16k, "GPT-3-Turbo-16k"),
        (gpt4, "GPT-4"),
        (gpt3,"GPT-3")
    ]
    model=models.CharField(
        max_length=20,
        choices=ai_models,
        default=gpt3_16k
    )

class Conversation(Base):
    bot=models.ForeignKey(Bot, on_delete=models.CASCADE, related_name="conversation")
    name=models.CharField(max_length=500,default='')
    email=models.CharField(max_length=500,default='')
    bookmarked=models.BooleanField(default=False)
    messages=models.TextField(default="[]")
    total_messages=models.IntegerField(default=0,null=True,blank=True)
    liked=models.BooleanField(default=False)
    profile_completed=models.BooleanField(default=False)
    incorrect_answers=models.IntegerField(default=0)
    other_info=models.TextField(default="{}")

class Rate(Base):
    watermark=models.IntegerField(default='1')
    chatbot=models.IntegerField(default='1')
    message=models.IntegerField(default='1')
    words=models.IntegerField(default='1')

class Plans(Base):
    name=models.CharField(max_length=100, null=True, blank=True)
    type=models.CharField(max_length=100, null=True, blank=True)
    price_id=models.CharField(max_length=250, null=True, blank=True)
    chat_credit=models.IntegerField(default=0,null=False,blank=False)
    chatbot_credit=models.IntegerField(default=0,null=False,blank=False)
    kb_credit=models.IntegerField(default=0,null=False,blank=False)
    monthly_price_id=models.CharField(max_length=250, null=True, blank=True)
    yearly_price_id=models.CharField(max_length=250, null=True, blank=True)
    storage=models.BigIntegerField(default=0)
    custom_branding=models.BooleanField(default=False)
    context_token=models.IntegerField(default=0)
    GPT3 = "gpt3"
    GPT4="gpt4"
    gpt_versions = [
        (GPT3, "GPT-3"),
        (GPT4, "GPT-4"),
    ]
    gpt_model=models.CharField(
        max_length=20,
        choices=gpt_versions,
        default=GPT3
    )

    def __str__(self):
        return "{} -> {}".format(self.name,self.type)
    
class Unverified(Base):
    email=models.CharField(max_length=250, null=True, blank=True)
    password=models.CharField(max_length=250, null=True, blank=True)
    country=models.CharField(max_length=100, null=True, blank=True)
    organisation=models.CharField(max_length=250, null=True, blank=True)
    name=models.CharField(max_length=200, null=True, blank=True)
    email_token=models.CharField(max_length=200, null=True, blank=True)
    phone=models.CharField(max_length=50, null=True, blank=True)
    token=models.CharField(max_length=50, null=True, blank=True)

class Invoice(Base):
    email=models.CharField(max_length=250, null=True, blank=True)
    user=models.ForeignKey(User, on_delete=models.CASCADE, related_name="Invoice")
    user_name=models.CharField(max_length=250,null=True,blank=True,default="")
    phone=models.CharField(max_length=250,null=True,blank=True,default="")
    status=models.CharField(max_length=250,null=True,blank=True,default="")
    amount=models.IntegerField(default=0)
    url=models.CharField(max_length=1000, null=True, blank=True)

class Terminated(Base):
    email=models.CharField(max_length=250, null=True, blank=True)
    date_joined=models.DateField(blank=True)
    reason=models.CharField(max_length=250, null=True, blank=True)
    cancelled_on=models.DateField(blank=True,null=True)
    paying=models.BooleanField(default=False)
    
class Api_keys(Base):
    openai=models.CharField(max_length=500,null=True,blank=True)
    