# Generated by Django 5.0.1 on 2024-01-10 07:24

import django.db.models.deletion
import uuid
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Api_keys',
            fields=[
                ('uid', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('date_created', models.DateTimeField(auto_now_add=True)),
                ('date_updated', models.DateTimeField(auto_now_add=True)),
                ('openai', models.CharField(blank=True, max_length=500, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Plans',
            fields=[
                ('uid', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('date_created', models.DateTimeField(auto_now_add=True)),
                ('date_updated', models.DateTimeField(auto_now_add=True)),
                ('name', models.CharField(blank=True, max_length=100, null=True)),
                ('type', models.CharField(blank=True, max_length=100, null=True)),
                ('price_id', models.CharField(blank=True, max_length=250, null=True)),
                ('chat_credit', models.IntegerField(default=0)),
                ('chatbot_credit', models.IntegerField(default=0)),
                ('kb_credit', models.IntegerField(default=0)),
                ('monthly_price_id', models.CharField(blank=True, max_length=250, null=True)),
                ('yearly_price_id', models.CharField(blank=True, max_length=250, null=True)),
                ('storage', models.BigIntegerField(default=0)),
                ('custom_branding', models.BooleanField(default=False)),
                ('context_token', models.IntegerField(default=0)),
                ('gpt_model', models.CharField(choices=[('gpt3', 'GPT-3'), ('gpt4', 'GPT-4')], default='gpt3', max_length=20)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Rate',
            fields=[
                ('uid', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('date_created', models.DateTimeField(auto_now_add=True)),
                ('date_updated', models.DateTimeField(auto_now_add=True)),
                ('watermark', models.IntegerField(default='1')),
                ('chatbot', models.IntegerField(default='1')),
                ('message', models.IntegerField(default='1')),
                ('words', models.IntegerField(default='1')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Terminated',
            fields=[
                ('uid', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('date_created', models.DateTimeField(auto_now_add=True)),
                ('date_updated', models.DateTimeField(auto_now_add=True)),
                ('email', models.CharField(blank=True, max_length=250, null=True)),
                ('date_joined', models.DateField(blank=True)),
                ('reason', models.CharField(blank=True, max_length=250, null=True)),
                ('cancelled_on', models.DateField(blank=True, null=True)),
                ('paying', models.BooleanField(default=False)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Unverified',
            fields=[
                ('uid', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('date_created', models.DateTimeField(auto_now_add=True)),
                ('date_updated', models.DateTimeField(auto_now_add=True)),
                ('email', models.CharField(blank=True, max_length=250, null=True)),
                ('password', models.CharField(blank=True, max_length=250, null=True)),
                ('country', models.CharField(blank=True, max_length=100, null=True)),
                ('organisation', models.CharField(blank=True, max_length=250, null=True)),
                ('name', models.CharField(blank=True, max_length=200, null=True)),
                ('email_token', models.CharField(blank=True, max_length=200, null=True)),
                ('phone', models.CharField(blank=True, max_length=50, null=True)),
                ('token', models.CharField(blank=True, max_length=50, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Bot',
            fields=[
                ('uid', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('date_created', models.DateTimeField(auto_now_add=True)),
                ('date_updated', models.DateTimeField(auto_now_add=True)),
                ('name', models.CharField(blank=True, default='', max_length=1000, null=True)),
                ('description', models.CharField(blank=True, default='', max_length=1000, null=True)),
                ('initial_message', models.TextField(default='')),
                ('kb_data', models.TextField(blank=True, default='{}')),
                ('token_usage', models.BigIntegerField(default=0)),
                ('prompt', models.TextField(blank=True, default='', null=True)),
                ('temperature', models.IntegerField(default=1)),
                ('appearance', models.TextField(blank=True, default='', null=True)),
                ('allowed_domains', models.TextField(blank=True, default='[]', null=True)),
                ('visibility', models.CharField(default='public', max_length=100)),
                ('model', models.CharField(choices=[('gpt-3.5-turbo-16k', 'GPT-3-Turbo-16k'), ('gpt-4', 'GPT-4'), ('gpt-3.5-turbo', 'GPT-3')], default='gpt-3.5-turbo-16k', max_length=20)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='Bot', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Conversation',
            fields=[
                ('uid', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('date_created', models.DateTimeField(auto_now_add=True)),
                ('date_updated', models.DateTimeField(auto_now_add=True)),
                ('name', models.CharField(default='', max_length=500)),
                ('email', models.CharField(default='', max_length=500)),
                ('bookmarked', models.BooleanField(default=False)),
                ('messages', models.TextField(default='[]')),
                ('total_messages', models.IntegerField(blank=True, default=0, null=True)),
                ('liked', models.BooleanField(default=False)),
                ('profile_completed', models.BooleanField(default=False)),
                ('incorrect_answers', models.IntegerField(default=0)),
                ('other_info', models.TextField(default='{}')),
                ('bot', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='conversation', to='main.bot')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Invoice',
            fields=[
                ('uid', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('date_created', models.DateTimeField(auto_now_add=True)),
                ('date_updated', models.DateTimeField(auto_now_add=True)),
                ('email', models.CharField(blank=True, max_length=250, null=True)),
                ('user_name', models.CharField(blank=True, default='', max_length=250, null=True)),
                ('phone', models.CharField(blank=True, default='', max_length=250, null=True)),
                ('status', models.CharField(blank=True, default='', max_length=250, null=True)),
                ('amount', models.IntegerField(default=0)),
                ('url', models.CharField(blank=True, max_length=1000, null=True)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='Invoice', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Profile',
            fields=[
                ('uid', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('date_created', models.DateTimeField(auto_now_add=True)),
                ('date_updated', models.DateTimeField(auto_now_add=True)),
                ('email', models.CharField(blank=True, max_length=100, null=True)),
                ('phone', models.CharField(blank=True, default='', max_length=250, null=True)),
                ('invalid_login_attempts', models.IntegerField(default=0)),
                ('reset_token', models.CharField(blank=True, max_length=100, null=True)),
                ('organisation', models.CharField(default='', max_length=50)),
                ('Country', models.CharField(default='', max_length=50)),
                ('plan', models.CharField(choices=[('basic', 'Basic'), ('starter', 'Starter'), ('standard', 'Standard'), ('business', 'Business'), ('free', 'Free')], default='free', max_length=20)),
                ('plan_duration', models.CharField(choices=[('yearly', 'Yearly'), ('monthly', 'Monthly'), ('unselected', 'Unselected')], default='unselected', max_length=20)),
                ('free_trial_ended', models.BooleanField(default=False)),
                ('last_updated_on', models.DateField(blank=True, null=True)),
                ('valid_till', models.DateField(blank=True, null=True)),
                ('chat_credit', models.IntegerField(default=0)),
                ('monthly_chat_credit', models.IntegerField(default=0)),
                ('chatbot_credit', models.IntegerField(default=0)),
                ('monthly_chatbot_credit', models.IntegerField(default=0)),
                ('message_usage', models.IntegerField(default=0)),
                ('token_usage', models.BigIntegerField(default=0)),
                ('kb_credit', models.IntegerField(default=0)),
                ('monthly_kb_credit', models.IntegerField(default=0)),
                ('remove_watermark', models.BooleanField(default=False)),
                ('remove_watermark_forever', models.BooleanField(default=False)),
                ('cancel_requested', models.BooleanField(default=False)),
                ('cancel_requested_date', models.DateField(blank=True, null=True)),
                ('cancellation_reason', models.CharField(blank=True, default='', max_length=250, null=True)),
                ('storage_usage', models.BigIntegerField(default=0)),
                ('stripe_customer_id', models.CharField(blank=True, default='', max_length=250, null=True)),
                ('stripe_subscription_id', models.CharField(blank=True, default='', max_length=250, null=True)),
                ('converted_on', models.DateField(blank=True, null=True)),
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='Profile', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='bot',
            name='profile',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='Bot', to='main.profile'),
        ),
    ]
