from django.contrib.auth.models import User
from rest_framework_simplejwt.tokens import AccessToken
from django.http import JsonResponse
from main.models import Profile
from datetime import datetime

def login(func):
	def action(request, *args, **kwargs):
		try:
			access_token=request.data['access_key']
			user_id=AccessToken(access_token)['user_id']
			user=User.objects.get(id=user_id)
			if(user.is_authenticated):
				return func(request,user)
			else:
				return JsonResponse({
					'status':401,
					'msg':'Not logged in'
				},status=200)
		except:
			return JsonResponse({
				'relogin':True,
				'status':401,
				'msg':'Not logged in'
			},status=200)	
	return action

def superuser_login(func):
	def action(request, *args, **kwargs):
		try:
			access_token=request.data['access_key']
			user_id=AccessToken(access_token)['user_id']
			user=User.objects.get(id=user_id)
			if(user.is_authenticated and user.is_superuser):
				return func(request,user)
			else:
				return JsonResponse({
					'status':401,
					'msg':'You are not authorized to access.'
				},status=200)
		except Exception as e:
			return JsonResponse({
				'relogin':True,
				'status':401,
				'msg':'Not logged in'
			},status=200)
		
	return action

